// Graph.h: interface for the CGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GRAPH_H__EAD01241_3666_418A_A584_8D62FDFE7BA2__INCLUDED_)
#define AFX_GRAPH_H__EAD01241_3666_418A_A584_8D62FDFE7BA2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SampleGrabber.h"

class CGraph   
{
public:

	CGraph();

	virtual ~CGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					SC_DEBUG( CHAR * fmt, ... );

	// GRAPH FUNCTIONS
	// 
	BOOL					CreateGraphBuilder();

	BOOL					CloseGraphBuilder( BOOL bDumpDebugMessage = TRUE );

	BOOL					SaveGraphBuilder( PWSTR pwszFilePathName );

	// FILTER FUNCTIONS
	// 
	BOOL					FindFilter( const GUID * pCategoryGUID, PWSTR pwszFiterName, UINT iDevNum, IBaseFilter ** ppBaseFilter, PWSTR pwszFilterNameBuffer, ULONG nFilterNameBufferSize );

    BOOL					AddFilter( IBaseFilter * pBaseFilter, PWSTR pwszFilterName );

    BOOL					RemoveFilter( IBaseFilter * pBaseFilter );

	BOOL					ConnectFilters( IBaseFilter * pUpBaseFilter, IBaseFilter * pDownBaseFilter, ULONG nUperFilterPinNum = 0 );

	BOOL					DisconnectFilters( IBaseFilter * pUpBaseFilter, IBaseFilter * pDownBaseFilter );

	// CONTROL FUNCTIONS
	// 
	OAFilterState			GetState();

	BOOL					Stop();

	BOOL					Pause();

	BOOL					Run();
	
public:

	// MEMBER VARIABLES
	// 
	IGraphBuilder *         m_pCommonGraphBuilder;

	ICaptureGraphBuilder2 * m_pCommonCaptureGraphBuilder2;

	IMediaControl *			m_pCommonMediaControl;

	IMediaEventEx *         m_pCommonMediaEventEx;

	IMediaFilter *			m_pCommonMediaFilter;
};

#endif // !defined(AFX_GRAPH_H__EAD01241_3666_418A_A584_8D62FDFE7BA2__INCLUDED_)
